<?php

defined('ABSPATH') || die();

// SHOW METAFIELDS THAT ARE GENERATED BY THE API PLUGIN
add_action('add_meta_boxes', 'add_api_generated_fields_meta_box', 10, 2);

function add_api_generated_fields_meta_box($post_type, $post)
{
    $isApiGeneratedPost = get_post_meta($post->ID, 'is__api__post');
    if (!is_array($isApiGeneratedPost) || empty($isApiGeneratedPost)) {
        remove_meta_box('api__generated_fields', null, 'normal');
        return;
    }
    if ($isApiGeneratedPost[0] == '1') :
        $fieldsLabel = __('Post meta fields (generated by the API)');
        add_meta_box('api__generated_fields', $fieldsLabel, 'api_fields_meta_box_echo');
    endif;
}

function api_fields_meta_box_echo($post)
{
    wp_enqueue_style('api_plugin_style', plugins_url('/api-fetcher/assets/adminstyle.css'));
?>
    <table class="api__output_table">
        <thead>
            <tr>
                <th colspan="4"><?php echo __('Post meta key field') ?></th>
                <th colspan="3"><?php echo __('Original response field name') ?></th>
                <th colspan="7"><?php echo __('Key value') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php
            $allPostMeta = get_post_meta($post->ID);
            foreach ($allPostMeta as $postMetaKey => $postMetaValue) :
                if (strpos($postMetaKey, 'api__field__') === 0) :
                    $originalKey = substr($postMetaKey, strlen('api__field__')) . '';
            ?>
                    <tr>
                        <td colspan="4"><?php echo $postMetaKey; ?></td>
                        <td colspan="3"><?php echo $originalKey; ?></td>
                        <td colspan="7"><?php echo ($postMetaValue[0]); ?></td>
                    </tr>
            <?php
                endif;
            endforeach;
            ?>
        </tbody>
    </table>
<?php
}
